/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks;

import blusunrize.immersiveengineering.api.energy.WrappingEnergyStorage;
import blusunrize.immersiveengineering.api.utils.DirectionUtils;
import blusunrize.immersiveengineering.api.utils.SafeChunkUtils;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.fluids.ArrayFluidHandler;
import blusunrize.immersiveengineering.common.util.ResettableCapability;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.ticks.ScheduledTick;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;

public abstract class IEBaseBlockEntity
extends BlockEntity
implements IEBlockInterfaces.BlockstateProvider {
    protected IEBlockInterfaces.IGeneralMultiblock tempMasterBE;
    @Nullable
    private BlockState overrideBlockState = null;
    private final EnumMap<Direction, Integer> redstoneBySide = new EnumMap(Direction.class);
    private final List<ResettableCapability<?>> caps = new ArrayList();
    private final List<Runnable> onCapInvalidate = new ArrayList<Runnable>();
    private boolean isUnloaded = false;

    public IEBaseBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void m_142466_(CompoundTag nbtIn) {
        super.m_142466_(nbtIn);
        this.readCustomNBT(nbtIn, false);
    }

    public abstract void readCustomNBT(CompoundTag var1, boolean var2);

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        this.writeCustomNBT(nbt, false);
    }

    public abstract void writeCustomNBT(CompoundTag var1, boolean var2);

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, be -> {
            CompoundTag nbttagcompound = new CompoundTag();
            this.writeCustomNBT(nbttagcompound, true);
            return nbttagcompound;
        });
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag nonNullTag = pkt.m_131708_() != null ? pkt.m_131708_() : new CompoundTag();
        this.readCustomNBT(nonNullTag, true);
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.readCustomNBT(tag, true);
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        this.writeCustomNBT(nbt, true);
        return nbt;
    }

    public void receiveMessageFromClient(CompoundTag message) {
    }

    public void receiveMessageFromServer(CompoundTag message) {
    }

    public void onEntityCollision(Level world, Entity entity) {
    }

    public boolean m_7531_(int id, int type) {
        if (id == 0 || id == 255) {
            this.markContainingBlockForUpdate(null);
            return true;
        }
        if (id == 254) {
            BlockState state = this.f_58857_.m_8055_(this.f_58858_);
            this.f_58857_.m_7260_(this.f_58858_, state, state, 3);
            return true;
        }
        return super.m_7531_(id, type);
    }

    public void markContainingBlockForUpdate(@Nullable BlockState newState) {
        if (this.f_58857_ != null) {
            this.markBlockForUpdate(this.m_58899_(), newState);
        }
    }

    public void markBlockForUpdate(BlockPos pos, @Nullable BlockState newState) {
        BlockState state = this.f_58857_.m_8055_(pos);
        if (newState == null) {
            newState = state;
        }
        this.f_58857_.m_7260_(pos, state, newState, 3);
        this.f_58857_.m_46672_(pos, newState.m_60734_());
    }

    protected <T> ResettableCapability<T> registerCapability(T val) {
        ResettableCapability<T> cap = new ResettableCapability<T>(val);
        this.caps.add(cap);
        return cap;
    }

    public void addCapInvalidateHook(Runnable hook) {
        this.onCapInvalidate.add(hook);
    }

    protected ResettableCapability<IEnergyStorage> registerEnergyInput(IEnergyStorage directStorage) {
        return this.registerCapability(new WrappingEnergyStorage(directStorage, true, false, this::m_6596_));
    }

    protected ResettableCapability<IEnergyStorage> registerEnergyOutput(IEnergyStorage directStorage) {
        return this.registerCapability(new WrappingEnergyStorage(directStorage, false, true, this::m_6596_));
    }

    private ResettableCapability<IFluidHandler> registerFluidHandler(IFluidTank[] tanks, boolean allowDrain, boolean allowFill) {
        return this.registerCapability(new ArrayFluidHandler(tanks, allowDrain, allowFill, () -> this.markContainingBlockForUpdate(null)));
    }

    protected final ResettableCapability<IFluidHandler> registerFluidHandler(IFluidTank ... tanks) {
        return this.registerFluidHandler(tanks, true, true);
    }

    protected final ResettableCapability<IFluidHandler> registerFluidInput(IFluidTank ... tanks) {
        return this.registerFluidHandler(tanks, false, true);
    }

    protected final ResettableCapability<IFluidHandler> registerFluidOutput(IFluidTank ... tanks) {
        return this.registerFluidHandler(tanks, true, false);
    }

    protected final ResettableCapability<IFluidHandler> registerFluidView(IFluidTank ... tanks) {
        return this.registerFluidHandler(tanks, false, false);
    }

    public final void m_7651_() {
        if (!this.isUnloaded) {
            this.setRemovedIE();
        }
        super.m_7651_();
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.resetAllCaps();
        this.caps.clear();
        this.onCapInvalidate.forEach(Runnable::run);
        this.onCapInvalidate.clear();
    }

    protected void resetAllCaps() {
        this.caps.forEach(ResettableCapability::reset);
    }

    public void onLoad() {
        super.onLoad();
        this.isUnloaded = false;
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        this.isUnloaded = true;
    }

    public void setRemovedIE() {
    }

    @Nonnull
    public Level getLevelNonnull() {
        return Objects.requireNonNull(super.m_58904_());
    }

    protected void checkLight() {
        this.checkLight(this.f_58858_);
    }

    protected void checkLight(BlockPos pos) {
        this.getLevelNonnull().m_183326_().m_183393_(new ScheduledTick((Object)this.m_58900_().m_60734_(), pos, 4L, 0L));
    }

    public void setOverrideState(@Nullable BlockState state) {
        this.overrideBlockState = state;
    }

    public BlockState m_58900_() {
        if (this.overrideBlockState != null) {
            return this.overrideBlockState;
        }
        return super.m_58900_();
    }

    @Deprecated
    public void m_155250_(BlockState newState) {
        BlockState old = this.m_58900_();
        super.m_155250_(newState);
        if (this.m_58903_().m_155262_(old) && !this.m_58903_().m_155262_(newState)) {
            this.setOverrideState(old);
        } else if (this.m_58903_().m_155262_(newState)) {
            this.setOverrideState(null);
        }
        this.resetAllCaps();
    }

    @Override
    public void setState(BlockState state) {
        if (this.getLevelNonnull().m_8055_(this.f_58858_) == this.getState()) {
            this.getLevelNonnull().m_46597_(this.f_58858_, state);
        }
    }

    @Override
    public BlockState getState() {
        return this.m_58900_();
    }

    protected void markChunkDirty() {
        if (this.f_58857_ != null && this.f_58857_.m_46805_(this.f_58858_)) {
            this.f_58857_.m_46745_(this.f_58858_).m_8092_(true);
        }
    }

    public void m_142339_(Level world) {
        super.m_142339_(world);
        this.redstoneBySide.clear();
    }

    public void m_6596_() {
        if (this.f_58857_ != null) {
            this.markChunkDirty();
            BlockState state = this.m_58900_();
            if (state.m_60807_()) {
                this.f_58857_.m_46717_(this.f_58858_, state.m_60734_());
            }
        }
    }

    protected void onNeighborBlockChange(BlockPos otherPos) {
        BlockPos delta = otherPos.m_141950_((Vec3i)this.f_58858_);
        Direction side = Direction.m_122372_((float)delta.m_123341_(), (float)delta.m_123342_(), (float)delta.m_123343_());
        Preconditions.checkNotNull((Object)side);
        this.updateRSForSide(side);
    }

    private void updateRSForSide(Direction side) {
        BlockState state;
        int rsStrength = this.getLevelNonnull().m_46681_(this.f_58858_.m_142300_(side), side);
        if (rsStrength == 0 && this instanceof IEBlockInterfaces.IRedstoneOutput && ((IEBlockInterfaces.IRedstoneOutput)((Object)this)).canConnectRedstone(side) && (state = SafeChunkUtils.getBlockState((LevelAccessor)this.f_58857_, this.f_58858_.m_142300_(side))).m_60734_() == Blocks.f_50088_ && (Integer)state.m_61143_((Property)RedStoneWireBlock.f_55500_) > rsStrength) {
            rsStrength = (Integer)state.m_61143_((Property)RedStoneWireBlock.f_55500_);
        }
        this.redstoneBySide.put(side, rsStrength);
    }

    protected int getRSInput(Direction from) {
        if (this.f_58857_.f_46443_ || !this.redstoneBySide.containsKey(from)) {
            this.updateRSForSide(from);
        }
        return this.redstoneBySide.get(from);
    }

    protected int getMaxRSInput() {
        int ret = 0;
        for (Direction d : DirectionUtils.VALUES) {
            ret = Math.max(ret, this.getRSInput(d));
        }
        return ret;
    }

    protected boolean isRSPowered() {
        for (Direction d : DirectionUtils.VALUES) {
            if (this.getRSInput(d) <= 0) continue;
            return true;
        }
        return false;
    }
}

